/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.console;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public final class SourceDisplayUtil {
    private SourceDisplayUtil() {
    }

    public static IEditorInput getEditorInput(Object element) {
        IResource file;
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof File) {
            return new FileStoreEditorInput(EFS.getLocalFileSystem().fromLocalFile((File)element));
        }
        if (element instanceof String && (file = ResourcesPlugin.getWorkspace().getRoot().findMember(element.toString())) != null) {
            if (file.getType() == 1 && file.isAccessible()) {
                return new FileEditorInput((IFile)file);
            }
            PHPDebugEPLPlugin.logError("Could not get the editor input. File does not exist or not accessible");
        }
        return null;
    }

    public static String getEditorId(IEditorInput input, Object element) {
        try {
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)input.getName());
            return descriptor.getId();
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public static void openInEditor(IEditorInput input, int lineNumber) throws PartInitException {
        SourceDisplayUtil.openInEditor(SourceDisplayUtil.getActivePage(), input, lineNumber);
    }

    public static void openInEditor(IWorkbenchPage page, IEditorInput input, int lineNumber) throws PartInitException {
        IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)SourceDisplayUtil.getEditorId(input, null));
        SourceDisplayUtil.revealLineInEditor(editorPart, lineNumber);
    }

    public static void revealLineInEditor(IEditorPart editorPart, int lineNumber) {
        IWorkbenchPage page;
        block8: {
            if (lineNumber > 0) {
                ITextEditor textEditor = null;
                textEditor = editorPart instanceof ITextEditor ? (ITextEditor)editorPart : (ITextEditor)editorPart.getAdapter(ITextEditor.class);
                if (textEditor != null) {
                    IDocumentProvider provider = textEditor.getDocumentProvider();
                    IDocument document = provider.getDocument((Object)textEditor.getEditorInput());
                    try {
                        try {
                            IRegion line = document.getLineInformation(lineNumber - 1);
                            textEditor.selectAndReveal(line.getOffset(), line.getLength());
                        }
                        catch (BadLocationException badLocationException) {
                            provider.disconnect((Object)document);
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        provider.disconnect((Object)document);
                        throw throwable;
                    }
                    provider.disconnect((Object)document);
                }
            }
        }
        if (!(page = editorPart.getSite().getPage()).isPartVisible((IWorkbenchPart)editorPart)) {
            page.activate((IWorkbenchPart)editorPart);
        }
    }

    public static IEditorPart findEditor(IEditorInput input) {
        return SourceDisplayUtil.getActivePage().findEditor(input);
    }

    private static IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }
}

